﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{


    public class ReportsDB
    {
        public static DataTable GetTop20Products(DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));

            return SQLHelper.ExecuteDataTable("spRptGetTop20Products", parameters);
        }

        public static DataTable GetProductsNeverPurchased(DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));

            return SQLHelper.ExecuteDataTable("spRptGetProductsNeverPurchased", parameters);
        }

        public static DataTable GetCustomersByOrderTotal(DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));

            return SQLHelper.ExecuteDataTable("spRptGetCustomersByOrderTotal", parameters);
        }

        public static DataTable GetCustomersByNoofOrders(DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));

            return SQLHelper.ExecuteDataTable("spRptGetCustomersByNoofOrders", parameters);
        }

        public static DataTable GetRegisteredCustomers(DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));

            return SQLHelper.ExecuteDataTable("spRptGetRegisteredCustomers", parameters);
        }

        public static DataTable GetSalesReport(DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));

            return SQLHelper.ExecuteDataTable("spRptGetSales", parameters);
        }

        public static DataTable GetMasterSalesReport(DateTime FromDate, DateTime ToDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@FromDate", (FromDate == DateTime.MinValue ? (object)DBNull.Value : FromDate)));
            parameters.Add(new SqlParameter("@ToDate", (ToDate == DateTime.MinValue ? (object)DBNull.Value : ToDate)));

            return SQLHelper.ExecuteDataTable("spRptGetTotalOrderDetails", parameters);
        }
    }
}
